unit CreateFolderFormUnit;
{
    UNIT CreateFormUnit;
    Version number 1.0.

This unit contains 'pBoy's YAFTP folder creating form and it's handling
routines.
Created by Pter Karsai }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TCreateFolderForm = class(TForm)
    GroupBox1      : TGroupBox;
    Label1         : TLabel;
    FolderNameEdit : TEdit;
    Image1         : TImage;
    CreateB: TButton; CancelB: TButton;
    procedure CreateBClick(Sender: TObject);
    procedure CancelBClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    ClickedButton: byte;  { button user clicked }
  public
    function RunDialog: string;
  end;

var
  CreateFolderForm: TCreateFolderForm;

{------------------------------------------------------------------------------}
implementation

uses FTPFormUnit;
{$R *.DFM}

{------------------------------------------------------------------------------}

function TCreateFolderForm.RunDialog: string;
begin
{ startup...}
    FTPForm.Enabled:= false;
    ClickedButton:= drNoButton;
    if Copy(GetCurrentDir, Length(GetCurrentDir), 1) <> '\' then
       FolderNameEdit.Text:= GetCurrentDir + '\'
    else
       FolderNameEdit.Text:= GetCurrentDir;

    Show;
{ wait for user's action }
    while ClickedButton = drNoButton do begin
          Application.ProcessMessages;
          if Application.Terminated then exit;
    end;
{ just return with clicked button constant }
    if ClickedButton = drCancel then
        Result:= ''
    else
        Result:= FolderNameEdit.Text;
{ close form }
    FTPForm.Enabled:= true;  { we want to click more and more :) }
    Close;
end;

{------------------------------------------------------------------------------}

procedure TCreateFolderForm.CreateBClick(Sender: TObject);
begin
    ClickedButton:= drDoIt;
end;

{------------------------------------------------------------------------------}

procedure TCreateFolderForm.CancelBClick(Sender: TObject);
begin
    ClickedButton:= drCancel;
end;

{------------------------------------------------------------------------------}

procedure TCreateFolderForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
    if ClickedButton = drNoButton then ClickedButton:= drCancel;
end;

end.
